
import cadquery as cq

# Create a sketch with a rectangle and a right trapezoid connected to its long side
base_length = 2.0
trapezoid_base_long = base_length
trapezoid_base_short = 1.0
trapezoid_height = 0.5

# Create the base rectangle
r = cq.Workplane("front").rect(base_length, base_length/2)

# Create and position the right trapezoid using polyline
r = r.pushPoints([(base_length/2, 0)]).polyline([
    (trapezoid_base_short / 2, trapezoid_height),
    (trapezoid_base_short / 2, -trapezoid_height),
    (-trapezoid_base_long / 2, -trapezoid_height)
]).close()

# Extrude the sketch to create a 3D object
result = r.extrude(1.0)

# Save the output
result.val().exportStl("Refine_1.stl")
