
import cadquery as cq

# Create the initial base square and extrude it
base_square = cq.Workplane("XY").rect(10, 10).extrude(1)

# Create the smaller square directly on top of the extruded base and extrude it by the same amount
# Ensure that both extrusions directly follow one another to meet the requirement
final_result = base_square.faces(">Z").workplane().rect(8, 8).extrude(1)

# Export the corrected results
final_result.val().exportStl("Refine_2.stl")
