
import cadquery as cq

# Parameters for the square block and the pipe
block_size = 10.0
block_height = 10.0
pipe_outer_radius = 2.0  # Outer radius of the annulus and pipe
pipe_inner_radius = 1.5  # Inner radius of the hole and inner circle of the annulus
annulus_height = block_height  # Height to ensure the annulus is the same as the block

# Create the square block
result = cq.Workplane("XY").box(block_size, block_size, block_height)

# Create the hole in the block
result = result.faces(">Z").workplane().hole(2 * pipe_inner_radius)

# Create and extrude the pipe with annulus
result = (
    result
    .faces(">Z").workplane()
    .circle(pipe_outer_radius)
    .circle(pipe_inner_radius)  # This ensures the annulus is created
    .extrude(annulus_height)
)

# Export the corrected result to STL
result.val().exportStl("Refine_2.stl")
