
import cadquery as cq

# Defined points for an irregular hexagon cut from a rectangle with more distinct cut-offs
# making the hexagonal shape clearer by defining new intersections.
points = [(0, 0), (10, 0), (10, 2), (8, 5), (2, 5), (0, 2)]

# Create the workplane and draw the hexagon
r = cq.Workplane("front").polyline(points).close()

# Extrude the hexagon
result = r.extrude(0.5)

# Export the modified result
result.val().exportStl("Refine_2.stl")
