
import cadquery as cq
import math

# Define the number of points, the radii, and angle variation
num_points = 5
outer_radius = 10.0
inner_radius = 5.0
angle_variation = math.pi / 20  # slight angle variation for each vertex

# Create the initial workplane
result = cq.Workplane("XY")

# Collect positions for outer and inner vertices with variable angles
outer_positions = [(outer_radius * math.cos(2 * math.pi * i / num_points + (i * angle_variation)),
                    outer_radius * math.sin(2 * math.pi * i / num_points + (i * angle_variation))) 
                   for i in range(num_points)]

inner_positions = [(inner_radius * math.cos(2 * math.pi * (i + 0.5) / num_points + (i * angle_variation)),
                    inner_radius * math.sin(2 * math.pi * (i + 0.5) / num_points + (i * angle_variation))) 
                   for i in range(num_points)]

# Initiate movement to the first outer position
result = result.moveTo(*outer_positions[0])

# Create the star by alternating with adjusted vertex angles
for i in range(num_points):
    next_outer = outer_positions[(i + 1) % num_points]
    next_inner = inner_positions[i]
    result = result.lineTo(*next_inner).lineTo(*next_outer)

# Close the shape and extrude
result = result.close().extrude(5.0)

# Export the updated model
result.val().exportStl("Refine_2.stl")
