
import cadquery as cq

# Define the dimensions
length = 20.0  # Length of the rectangle
width = 10.0   # Width of the rectangle
height = 5.0   # Height of the rectangle
cylinder_height = 10.0  # Height of the cylinder
cylinder_diameter = length / 4  # Diameter of the cylinder should be 1/4th of the length of the rectangle

print(f"Cylinder Diameter: {cylinder_diameter}, Expected: {length / 4}")

# Create the rectangle
result = cq.Workplane("XY").box(length, width, height)

# Create the cylinder
result = result.faces(">Z").workplane().circle(cylinder_diameter / 2.0).extrude(cylinder_height)

# Export the result with the correct file name
result.val().exportStl("Refine_2.stl")
