
import cadquery as cq

# Define the dimensions
rect_length = 10.0
rect_width = 5.0
trap_height = 5.0
trap_small_base = 5.0
trap_large_base = rect_length
extrude_amount = 20.0

# Create the rectangle
result = cq.Workplane("front").rect(rect_length, rect_width)

# Create the trapezium
result = result.moveTo(0, rect_width / 2).lineTo(trap_small_base / 2, trap_height).lineTo(-trap_small_base / 2, trap_height).close()

# Extrude the sketch
result = result.extrude(extrude_amount)

# Export the result
result.val().exportStl("Generated.stl")
