
import cadquery as cq

# Create a cylinder
cylinder = cq.Workplane("XY").circle(10).extrude(20)

# Adjust the dimensions to accurately define the trapezium on the top surface of the cylinder
# and position the trapezium to cut out from the top of the cylinder
trapezium = (
    cq.Workplane("XY")
    .circle(10).extrude(20)  # re-extrude to position operations at top surface
    .faces(">Z")  # select the top face
    .workplane()  # create a work plane on the top face
    .moveTo(1, -1).lineTo(1, 1).lineTo(2, 1.5).lineTo(2, -1.5).close()  # draw and close trapezium
    .cutThruAll()  # cut the shape through the entire thickness
)

# Subtract the trapezium from the cylinder to create the desired cutout
result = cylinder.cut(trapezium)

# Export the STL file with the corrected name as requested
result.val().exportStl("Refine_1.stl")
