
import cadquery as cq

# Define the dimensions
width = 90.0
height = 60.0
cutout_size = width / 3.0

# Create the large rectangle and extrude
base = cq.Workplane("front").box(width, height, 10)  # extrusion thickness can be adjusted as needed

# Calculate position for the cutout so its top edge is at the center of the top edge of the rectangle
cutout_x = 0  # centered in x
cutout_y = height / 2 - cutout_size / 2  # position y so top edge is at center of rectangle's top edge

# Create the square cutout and cut it from the base shape
cutout = cq.Workplane("front").transformed(offset=(cutout_x, cutout_y, 5))\
    .box(cutout_size, cutout_size, 10, centered=(True, True, False))  # extrude and position cutout

result = base.cut(cutout)  # Subtract the cutout from the base

# Save the output
result.val().exportStl("Refine_1.stl")
