
import cadquery as cq

# Create the base rectangle
base = cq.Workplane("XY").rect(3, 2).extrude(1)

# Ensuring the smaller rectangle cutout is perfectly centered and has the correct dimensions
# Using center=True to automatically center it on the face
cutout = cq.Workplane("XY").workplane(offset=1).rect(2, 1.33, centered=True).extrude(-1)

# Combine the base and the cutout
result = base.cut(cutout)

# Export the result with adjusted name
result.val().exportStl("Refine_1.stl")
