
import cadquery as cq

# Create the base rectangle
base = cq.Workplane("XY").rect(3, 2).extrude(1)

# Ensuring the smaller rectangle cutout is perfectly centered and has the correct dimensions
# 2/3 of the 3 units wide base rectangle is 2 units
# Centering it on the face by selecting the top face and then centering the smaller rectangle
cutout = base.faces(">Z").workplane().rect(2, 1.33).extrude(-1)

# Combine the base and the cutout
result = base.cut(cutout)

# Export the result with adjusted name
result.val().exportStl("Refine_2.stl")
