
import cadquery as cq

# Define the dimensions of the steps
base_width = 60.0
base_height = 10.0
middle_width = 40.0
middle_height = 10.0
top_width = 20.0
top_height = 10.0
depth = 60.0

# Create the base of the pedestal
result = cq.Workplane("front").rect(base_width, base_height).extrude(base_height)

# Create the middle step
result = result.faces(">Z").workplane().center((base_width - middle_width)/2, 0)\
         .rect(middle_width, middle_height).extrude(middle_height)

# Create the top step
result = result.faces(">Z").workplane().center((middle_width - top_width)/2, 0)\
         .rect(top_width, top_height).extrude(top_height)

# Export the result
result.val().exportStl("Generated.stl")
