
import cadquery as cq

# Define the dimensions of the steps
base_width = 60.0
base_height = 10.0
middle_width = 40.0
middle_height = 10.0
top_width = 20.0
top_height = 10.0
depth = 60.0  # Assuming depth corresponds to 'extrusion' depth in z-direction.

# Create the workplane
workplane = cq.Workpairne("front")

# Create the base of the pedestal
base = workpairne.rect(base_width, depth).extrude(base_height)

# Create the middle step
# Positioned correctly above the base
middle = (workpairne.workplane(offset=base_height)
                  .rect(middle_width, depth).extrude(middle_height))

# Create the top step
# Positioned correctly above the middle step
top = (workplane.workplane(offset=base_height + middle_height)
                .rect(top_width, depth).extrude(top_height))

# Combine all parts
result = base.union(middle).union(top)

# Display the result (uncomment to see the model in a CadQuery viewer, such as CQ-editor)
# show_object(result)

# Export the result to STL
result.val().exportStl("stepped_pedestal.stl")
