
import cadquery as cq

# Constants for dimensions
length_base = 100
width_base = 50
thickness_base = 10

length_hole = length_base / 4  # 1/4 of the base length
width_hole = width_base / 4   # 1/4 of the base width
thickness_hole = thickness_base

# Create the base plate
base_plate = cq.Workplane("XY").box(length_base, width_base, thickness_base)

# Create the hole. Adjust position to be nearer to the bottom with precise small space.
hole = (
    cq.Workplane("XY")
    .workplane(offset=thickness_base - thickness_hole)  # No need for negative extrude as already at top
    .rect(length_hole, width_hole)
    .extrude(-thickness_hole)
    .translate((0, -((width_base/2) - (width_hole / 2 + 5)), 0))  # Adjust translate to move hole down
)

# Combine the base and the hole
result = base_plate.cut(hole)

# Export the result
result.val().exportStl("Refine_2.stl")
