
import cadquery as cq
from math import cos, sin, radians  # Necessary imports for trigonometric functions

# Parameters for the cylinder and the cutout
outer_radius = 10
inner_radius = 9  # Ensure there is a noticeable difference yet keeping the object practical
angle_degrees = 60
extrude_height = 5

# Helper function to create a sector with given parameters
def create_sector(radius, angle_degrees, height, mode='outer'):
    # Adjust the endpoints for the sector's radius arc based on the mode
    wp = (cq.Workplane("XY")
          .moveTo(0, 0)
          .lineTo(radius, 0)
          .radiusArc((radius * cos(radians(angle_degrees)), radius * sin(radians(angle_degrees))), radius)
          .lineTo(0, 0)
          .close())
          
    if mode == 'outer':
        return wp.extrude(height)
    else:
        return wp.extrude(-height)

# Create the outer cylinder sector
outer_sector = create_sector(outer_radius, angle_degrees, extrude_height, 'outer')

# Create the inner cylinder sector slightly lower to ensure it cuts throughout
# Translate the inner sector up to match the top surface of the outer sector
inner_sector = create_sector(inner_radius, angle_degrees, extrude_height, 'inner').translate((0, 0, extrude_height))

# Subtract the inner sector from the outer sector to create the hollow cylinder sector
result = outer_sector.cut(inner_sector)

# Export the result
result.val().exportStl("Refine_2.stl")
