
import cadquery as cq

# Parameters for the hexagonal head and the screw
head_diameter = 10.0
head_height = 5.0
screw_diameter = 4.0
screw_length = 20.0
screw_protrusion = 0.5  # Additional protrusion above the hex head

# Create the hexagonal head
result = cq.Workplane("XY").polygon(6, head_diameter).extrude(head_height)

# Create the screw, making it protrude a bit above the head
result = result.faces(">Z").workplane().circle(screw_diameter / 2).extrude(screw_length + screw_protrusion)

# Export the result to STL with updated file name as per requirement
result.val().exportStl("Refine_2.stl")
