
import cadquery as cq

# Create the first hexagon and extrude it
result = cq.Workplane("XY").polygon(6, 10.0).extrude(5.0)

# Create rotated second hexagon on top of the first and extrude it
result = result.faces(">Z").workplane().transformed(rotate=(0, 0, 30)).polygon(6, 8.0).extrude(4.0)

# Create rotated third hexagon on top of the second and extrude it
result = result.faces(">Z").workplane().transformed(rotate=(0, 0, 60)).polygon(6, 6.0).extrude(3.0)

# Create rotated triangle on top of the third hexagon and extrude it
result = result.faces(">Z").workplane().transformed(rotate=(0, 0, 90)).polygon(3, 4.0).extrude(2.0)

# Save the result
result.val().exportStl("Refine_1.stl")
