
import cadquery as cq

# Define the points the spline will pass through
points = [
    (0, 0),
    (0.5, 0.5),
    (0.5, 1.5),
    (0, 2),
    (-0.5, 1.5),
    (-0.5, 0.5),
    (0, 0)
]

# Create a workplane that an object can be built on
# Use the named plane orientation "front" to define the workplane
# Draw the spline through the defined points
# Mirror the spline about the Y axis to create the heart shape
# Extrude the heart shape to create a 3D object
result = (
    cq.Workplane("front")
    .spline(points)
    .mirrorY()
    .extrude(1)
)

# Export the result to STL
result.val().exportStl("Generated.stl")
