
import cadquery as cq

# Create a cylinder
cylinder = cq.Workplane("XY").circle(5).extrude(20)

# Create a circle larger than the cylinder's size and start the placement right at the top of the cylinder
circle = cq.Workplane("XY").workplane(offset=20).circle(10).extrude(5)

# Combine the cylinder and the circle
result = cylinder.union(circle)

# Save the output with a new name and as specified in your requirement
result.val().exportStl("Refine_2.stl")
