
import cadquery as cq

# Define the parameters
square_size = 10
extrude_height = 1
hole_diameter = 0.5
cylinder_outer_radius = 2
cylinder_inner_radius = 1.5
cylinder_height = extrude_height * 2  # Ensure the cylinder extends through

# Adjustment to offset to ensure clear placement 1 unit away from each edge
corner_offset = 1  

# Create a square and slightly extrude it
result = cq.Workplane("XY").rect(square_size, square_size).extrude(extrude_height)

# Create four tiny circular holes, positioning each one near a corner
result = result.faces(">Z").workplane().pushPoints([
    (square_size / 2 - corner_offset, square_size / 2 - corner_offset),
    (-square_size / 2 + corner_offset, square_size / 2 - corner_offset),
    (square_size / 2 - corner_offset, -square_size / 2 + corner_offset),
    (-square_size / 2 + corner_offset, -square_size / 2 + corner_offset)
]).hole(hole_diameter)

# Create a hollow cylinder and extrude it, positioning it so that it intersects the square in the middle
result = result.faces(">Z").workplane().circle(cylinder_outer_radius).circle(cylinder_inner_radius).extrude(cylinder_height, both=True)

# Save the adjusted model
result.val().exportStl("Refine_2.stl")
