
import cadquery as cq

# Create a square
result = cq.Workplane("front").rect(2, 2)

# Attach a semi-circle to the top of the square
# Ensure the semi-circle is correctly centered over the square
result = result.moveTo(0, 1).threePointArc((1, 2), (2, 1))

# Extrusion of the properly closed sketch
result = result.close().extrude(1)

# Save the output, adjusting file name as specified
result.val().exportStl("Refine_2.stl")
