
import cadquery as cq

# Define the dimensions of the U-shaped table
table_length = 10.0
table_width = 4.0
table_height = 1.0
leg_width = 2.0  # Made the legs slightly wider as per description
leg_height = 4.0
mid_section_width = 1.5  # Width of the middle section, less than leg_width

# Create the U-shape
u_shape = (cq.Workplane("XY")
           .moveTo(-table_length / 2, -table_width / 2)
           .lineTo(-table_length / 2 + leg_width, -table_width / 2)
           .lineTo(-table_length / 2 + leg_width, table_width / 2 - mid_section_width)
           .lineTo(table_length / 2 - leg_width, table_width / 2 - mid_section_width)
           .lineTo(table_length / 2 - leg_width, -table_width / 2)
           .lineTo(table_length / 2, -table_width / 2)
           .close()
           .extrude(table_height))

# Create legs
leg1 = (
    cq.Workplane("XY")
    .workplane(offset=table_height)
    .moveTo(-table_length / 2 + leg_width / 2, -table_width / 2)
    .box(leg_width, leg_width, leg_height)
)
leg2 = (
    cq.Workplane("XY")
    .workplane(offset=table_height)
    .moveTo(table_length / 2 - leg_width / 2, -table_width / 2)
    .box(leg_width, leg_width, leg_height)
)

# Combine all the parts
result = u_shape.union(leg1).union(leg2)

# Export the result
result.val().exportStl("Refine_1.stl")
