
import cadquery as cq

# Improved dimensions to ensure visibility of leg width being greater than mid-section width
table_length = 10.0
table_width = 4.0
table_height = 1.0
leg_width = 2.2  # Slightly increase leg width
leg_height = 4.0
mid_section_width = 1.5  # Confirming this to be less than leg width, original was fine but emphasizing here

# Create the U-shape
u_shape = (cq.Workplane("XY")
           .moveTo(-table_length / 2, -table_width / 2)
           .lineTo(-table_length / 2 + leg_width, -table_width / 2)
           .lineTo(-table_length / 2 + leg_width, table_width / 2 - mid_section_width)
           .lineTo(table_length / 2 - leg_width, table_width / 2 - mid_section_width)
           .lineTo(table_length / 2 - leg_width, -table_width / 2)
           .lineTo(table_length / 2, -table_width / 2)
           .close()
           .extrude(table_height))

# Create legs
leg1 = (
    cq.Workplane("XY")
    .workplane(offset=table_height)
    .moveTo(-table_length / 2 + leg_width / 2, -table_width / 2)
    .box(leg_width, leg_width, leg_height)
)
leg2 = (
    cq.Workplane("XY")
    .workplane(offset=table_height)
    .moveTo(table_length / 2 - leg_width / 2, -table_width / 2)
    .box(leg_width, leg_width, leg_height)
)

# Combine all the parts
result = u_shape.union(leg1).union(leg2)

# Export the revised result
result.val().exportStl("Refine_2.stl")
