
import cadquery as cq

# Create a rectangle
rectangle = cq.Workplane("front").rect(10, 5)

# Extrude the sketch
extruded_rectangle = rectangle.extrude(2)

# Round two corners of the same long edge
rounded_extrusion = extruded_rectangle.edges("|Z and >X").fillet(1)
rounded_extrusion = rounded_extrusion.edges("|Z and <X").fillet(1)

# Create two small, evenly-spaced circular holes on the same side as the rounded corners closer to the corners
# These holes are positioned with Y values closer to the curved edge and slightly closer inward along the X axis.
final_object = rounded_extrusion.faces(">Z").workplane().pushPoints([(-4, 1), (4, 1)]).hole(0.5)

# Save the output with the updated filename
final_object.val().exportStl("Refine_2.stl")
