
import cadquery as cq
import math

# Define dimensions and properties
vertical_height = 15
horizontal_length = 3
thickness = 2
curve_radius = 1
extrude_depth = 2

# Create the sketch for a vertical L-shape with just the vertical curve
result = (
    cq.Workplane("front")
    .vLine(vertical_height - curve_radius)  # Vertical line up
    .threePointArc((curve_radius, vertical_height), (curve_radius * 2, vertical_height - curve_radius))  # Curved top
    .hLineTo(horizontal_length)  # Horizontal line right
    .vLineTo(0)  # Vertical line down to origin
    .close()  # Close the sketch
    .extrude(extrude_depth)  # Extrude the shape
)

# Export the altered design
result.val().exportStl("Refine_2.stl")
