
import cadquery as cq

# Create a rectangular block
block = cq.Workplane("XY").rect(10, 20).extrude(5)  # Rectangle 10 x 20 and extruded by 5

# Create a semi-circular cutout on the longer side, ensuring that the semi-circle is aligned properly
cutout = block.faces(">Z").workplane().center(-5, 0).rect(10, 10).cutBlind(-5)

# Export the result
cutout.val().exportStl("Refine_1.stl")
