
import cadquery as cq

# Create a rectangular block
block = cq.Workplane("XY").rect(10, 20).extrude(5)  # Rectangle 10 x 20 and extruded by 5

# Create a semi-circular cutout on the longer side.
# The flat side of the semi-circle should be on the longer side of the rectangle
radius = 5
cutout = block.faces(">Z").workplane(centerOption="CenterOfBoundBox").center(-5, 0).circle(radius).cutBlind(-5)

# Export the result
cutout.val().exportStl("Refine_2.stl")
