
import cadquery as cq

# Define dimensions
table_height = 10.0
table_width = 3.0  # Adjusted table width to balance the proportions
table_thickness = 1.0
hole_diameter = 0.5
leg_width = 2.0  # Width of the legs is now defined to make it visibly twice the upper width

# Create the "U"-shaped sketch with adjusted proportions for the legs
sketch = (
    cq.Workplane("front")
    .moveTo(-leg_width, 0)
    .lineTo(-leg_width, table_height)  # Draw first leg
    .lineTo(leg_width, table_height)   # Top horizontal line
    .lineTo(leg_width, 0)              # Draw second leg
    .lineTo(table_width / 2, 0)        # Start inner cut
    .lineTo(table_width / 2, table_height - table_thickness)
    .lineTo(-table_width / 2, table_height - table_thickness)
    .lineTo(-table_width / 2, 0)
    .close()
)

# Extrude the sketch in the opposite (negative z-axis) direction to simulate the inverted table
table = sketch.extrude(-table_thickness)

# Create the hole in the center of the table; adjusted the workplane centering 
table_with_hole = table.faces(">Z").workplane(centerOption="CenterOfMass").hole(hole_diameter)

# Export the corrected model
table_with_hole.val().exportStl("Refine_1.stl")
