
import cadquery as cq

# Define dimensions
table_height = 10.0
table_thickness = 1.0
hole_diameter = 0.5
leg_width = 3.0  # Define as required proportion
horizontal_section_width = leg_width / 2  # Half the width of the legs

# Create the "U"-shaped sketch
sketch = (
    cq.Workplane("front")
    .moveTo(-leg_width, 0)
    .lineTo(-leg_width, table_height)  # Draw first leg
    .lineTo(leg_width, table_height)   # Top horizontal line
    .lineTo(leg_width, 0)              # Draw second leg
    .lineTo(horizontal_section_width / 2, 0)  # Correct inner dimensions
    .lineTo(horizontal_section_width / 2, table_height - table_thickness)
    .lineTo(-horizontal_section_width / 2, table_height - table_thickness)
    .lineTo(-horizontal_section_width / 2, 0)
    .close()
)

# Extrude the sketch in the opposite (negative z-axis) direction
table = sketch.extrude(-table_thickness)

# Create the hole in the center of the table
table_with_hole = table.faces(">Z").workplane(centerOption="CenterOfMass").hole(hole_diameter)

# Export the corrected model
table_with_hole.val().exportStl("Refine_2.stl")
