
import cadquery as cq

# Define the points the polyline will be drawn through
points = [(0, 0), (0, 10), (10, 10), (10, 8), (2, 8), (2, 0)]

# Create a workplane and draw the polyline
r = cq.Workplane("front").polyline(points)

# Close the polyline and extrude to create the bracket
result = r.close().extrude(2)

# Export the result to STL with the corrected file name
result.val().exportStl("Refine_2.stl")
