
import cadtools as cq

# Define the dimensions
rect_length = 30.0
rect_width = 10.0
semi_hex_length = rect_length * 2 / 3
semi_hex_height = rect_width  # Matching semi-hex height if needed

# Start a new sketch
sketch = cq.Sketch()

# Create the rectangle
sketch.rect(rect_length, rect_width)

# Coordinates for the semi-hexagonal section
# Points defining the semi-hexagon
points = [
    (0, rect_width),                                    # Starting at one end of rectangle
    (semi_hex_length, rect_width),                      # Horizontal line
    (semi_hex_length, rect_width + semi_hex_height),    # Vertical line up
    (semi_hex_length - semi_hex_length / 2, rect_width + semi_hex_height),  # Middle top of hex
    (0, rect_width + semi_hex_height)                   # Vertical line down
]

# Connecting the points with straight lines
for i in range(len(points) - 1):
    if i == 0:
        sketch.moveTo(*points[i])
    sketch.lineTo(*points[i + 1])
sketch.lineTo(points[0][0], points[0][1])  # Closing the sketch by connecting back to the start

# Extrude the entire sketch
result = sketch.extrude(rect_width)  # Extrusion depth same as the rectangle width could be changed based on requirements

# Save the output
result.val().exportStl("Refine_2.stl")
