
import cadquery as cq

# Create a rectangular block
result = cq.Workplane("XY").rect(10, 2).extrude(0.5)

# Adjusting the positions of the holes to form a more distinct triangular pattern
result = result.faces(">Z").workplane().pushPoints([
    (0, 0),  # Center hole
    (-1, 0.5),  # Left hole, adjusted to be more separated and aligned in Y
    (1, 0.5)   # Right hole, adjusted to be more separated and aligned in Y
]).hole(0.2)

# Export the result with the correct output filename
result.val().exportStl("Refine_1.stl")
