
import cadquery as cq

# Create a rectangular block
result = cq.Workplane("XY").rect(10, 2).extrude(0.5)

# Adjusting the positions of the holes to form a clearer triangular pattern
result = result.faces(">Z").workplane().pushPoints([
    (0, 0),        # Center hole
    (-2, 0.5),     # Left hole, moved further left and slightly up
    (2, 0.5)       # Right hole, moved further right and slightly up
]).hole(0.2)

# Export the result with the correct output filename and updated filename for clarification of revision
result.val().exportStl("Refine_2.stl")
