
import cadquery as cq

# Define the dimensions
width = 20.0
height = width / 20
square_side = width / 2
extrude_depth = width * 20

# Create base rectangle
base = cq.Workplane("front").rect(width, height).extrude(extrude_depth)

# Adjust the correct positioning of the first square: placing it so that its bottom right corner coincides with the top right of the rectangle
first_square = base.faces(">Z").workplane().transformed(offset=(square_side / 2, height, 0)).rect(square_side, square_side).extrude(extrude_depth)

# Correct position and size of the second, slightly smaller square
second_square_offset = square_side - square_side * 0.01 / 2
second_square = first_square.faces(">Z").workplane().transformed(offset=(second_square_offset, square_side * 0.99, 0)).rect(square_side * 0.99, square_side * 0.99).extrude(extrude_depth)

# Combine all parts
result = first_square.union(second_square)

# Export the result with the correct file name
result.val().exportStl("Refine_1.stl")
