
import cadquery as cq

# Define the dimensions
width = 20.0
height = width / 20
square_side = width / 2
extrude_depth = width * 20

# Adjust the positioning of the rectangles and squares
# Create the base rectangle
assembly = cq.Workplane("front").rect(width, height).extrude(extrude_depth)

# Adjust the position of the first square:
# Bottom right corner is coincident with the top right corner of the rectangle
first_square = assembly.faces(">Z").workplane().transformed(offset=(width / 4, height / 2, 0)).rect(square_side, square_side).extrude(extrude_depth)

# Place the second square so that its bottom right corner is coincident with the top right corner of the first square
second_square = first_square.faces(">Z").workplane().transformed(offset=(square_side / 2, square_side / 2, 0)).rect(square_side * 0.99, square_side * 0.99).extrude(extrude_depth)

# Combine all parts
final_object = assembly.union(first_square).union(second_square)

# Export the result with the correct file name as per revised requirements
final_object.val().exportStl("Refine_2.stl")
