
import cadquery as cq

# Define the dimensions of the original rectangle and the cutout
length = 100.0  # Length of the original rectangle
width = 20.0  # Width of the original rectangle
thickness = 2.0  # Thickness of the original rectangle
cutout_length = length / 4.0  # Length of the cutout
cutout_width = width / 2.0  # Width of the cutout

# Create the original rectangle
result = (
    cq.Workplane("XY")
    .rect(length, width)
    .extrude(thickness)
)

# Define the positioning of the cutout
cutout_x = length - cutout_length - 10  # X position offset from the right edge of the rectangle
cutout_y = -width / 4  # Y position from the center of the rectangle to place it towards the bottom

# Create the cutout
result = (
    result.faces(">Z")
    .workplane(centerOption="CenterOfMass")
    .transformed(offset=(cutout_x, cutout_y, 0))
    .rect(cutout_length, cutout_width)
    .cutBlind(-thickness)
)

# Export the result
result.val().exportStl("Refine_2.stl")
