
import cadquery as cq

# Define the 3D extrusion height
height = 5

# Create the workplane and the base rectangle
workplane = cq.Workplane("XY")
base = workplane.rect(10, 20)  # Base rectangle dimensions

# Create and merge the smaller rectangles correctly positioned to ensure proper puzzle piece-like extensions
# Align smaller rectangles at the center of the long edges
small_rect1 = workplane.rect(5, 10).translate((0, 15))  # Centered on one long edge
small_rect2 = workplane.rect(5, 10).translate((0, -15)) # Centered on the opposite long edge

# Combine all shapes and extrude
result = (base.add(small_rect1).add(small_rect2)).extrude(height)

# Create the large circular hole
result = result.faces(">Z").workplane().hole(10)  # Hole diameter remains the same if previously correct

# Export the result
result.val().exportStl("Refine_2.stl")
