
import cadquery as cq
import math

# Parameters for the cylinder and holes
diameter = 100.0  # Diameter of the main cylinder
height = 20.0  # Height of the main cylinder
center_hole_diameter = diameter / 8  # Diameter of the center hole
small_hole_diameter = center_hole_diameter / 4  # Diameter of the small holes
small_hole_offset = center_hole_diameter * 1.5  # Offset of the small holes from the center

# Create the main cylinder
result = cq.Workplane("XY").circle(diameter / 2).extrude(height)

# Create the center hole
result = result.faces(">Z").workplane().hole(center_hole_diameter)

# Create the small holes in a triangular formation
for angle in [0, 120, 240]:  # Angles for triangulation
    # Convert angle to radians and calculate x, y coordinates
    x = small_hole_offset * math.cos(math.radians(angle))
    y = small_hole_offset * math.sin(math.radians(angle))
    # Positioning the hole using x, y coordinates directly in hole creation
    result = result.faces(">Z").workplane(centerOption="ProjectedOrigin").moveTo(x, y).hole(small_hole_diameter)

# Optional: Uncomment the following line to display the result in a Jupyter notebook environment
# display(result)

# Export the result as an STL file
# Please note: Uncomment this line if running in a local environment where file writing is required.
result.val().exportStl("Refine_2.stl")
