
import cadquery as cq

# Define the dimensions of the rectangle and the holes
length = 100.0  # Length of the rectangle
width = 50.0  # Width of the rectangle
thickness = 10.0  # Thickness of the rectangle
hole_diameter = 5.0  # Diameter of the holes

# Create the rectangle
result = (
    cq.Workplane("XY")
    .box(length, width, thickness)
)

# Create the holes
hole_spacing = width / 4  # Adjust hole spacing based on the width
offset_from_center = length * 0.1  # Offset from the center towards one side
for i in range(3):
    result = (
        result.faces(">Z")
        .workplane(centerOption="CenterOfMass")
        .center(-length / 2 + offset_from_center, (i-1) * hole_spacing)  # Adjusted position to align on one side
        .hole(hole_diameter)
    )

# Export the result
result.val().exportStl("Refine_2.stl")
