
import cadquery as cq

# Parameters for the bucket and handle
bucket_height = 10.0
bucket_radius = 5.0
bucket_thickness = 0.5
handle_diameter = 0.5
handle_length = 2 * (bucket_radius + bucket_thickness)  # slightly larger than the diameter plus thickness

# Create the outer cylinder of the bucket
bucket = cq.Workplane("XY").circle(bucket_radius).extrude(bucket_height)

# Create the inner cylinder of the bucket
bucket = bucket.faces(">Z").workplane().circle(bucket_radius - bucket_thickness).cutBlind(-bucket_height + bucket_thickness)

# Handle placement with intersections through the cylinder sides
handle = cq.Workplane("XY").transformed(offset=(0, 0, 1)).circle(handle_diameter / 2).extrude(handle_length, both=True)

# Rotate handle to the correct orientation and position it cutting through the bucket
handle = handle.rotate((1, 0, 0), (0, 0, 1), 90)
handle = handle.translate((bucket_radius, 0, bucket_height - bucket_thickness - 1))

# Combine the bucket and the handle
result = bucket.union(handle)

# Save the final model
result.val().exportStl("Refine_2.stl")
