
import cadquery as cq

# Create a cylinder
cylinder = cq.Workplane("XY").circle(10).extrude(20)

# Negatively extrude a regular octagon to create a hole that cuts through the entire cylinder
result = cylinder.faces(">Z").workplane().polygon(8, 5).cutThruAll()

# Save the output
result.val().exportStl("Refine_2.stl")
