
import cadquery as cq

# Dimensions for the table
table_length = 100.0
table_width = 60.0
table_thickness = 5.0
leg_length = 20.0
leg_width = 10.0
leg_height = 50.0

# Create the table top
table = cq.Workplane("XY").box(table_length, table_width, table_thickness)

# Create the two symmetrically placed legs at each end of the rectangle
leg1 = (
    cq.Workplane("XY")
    .workplane(offset=table_thickness)
    .moveTo(-table_length/2 + leg_length/2, 0)
    .rect(leg_length, leg_width)
    .extrude(leg_height)
)
leg2 = (
    cq.Workplane("XY")
    .workplane(offset=table_thickness)
    .moveTo(table_length/2 - leg_length/2, 0)
    .rect(leg_length, leg_width)
    .extrude(leg_height)
)

# Combine the table top and the two legs
result = table.union(leg1).union(leg2)

# Export the result
result.val().exportStl("Refine_1.stl")
