
import cadquery as cq
import math

# Create a regular hexagon
hexagon = cq.Workplane("XY").polygon(6, 20).extrude(10)  # Adjusted to a larger size for better visualization

# Create a smaller square on top of the hexagon, ensuring correct centering and proportional sizing
square = (cq.Workplane("XY")
          .workplane(offset=10)  # Match the extrusion height of the hexagon
          .transformed(rotate=(0, 0, 45))  # Rotate 45 degrees to ensure no parallel edges with the hexagon
          .rect(12, 12)  # Adjust size to make it visually balanced with the hexagon
          .extrude(10))  # Extrusion height

# Combine the hexagon and the square
result = hexagon.union(square)

# Export the result with updated filename as requested
result.val().exportStl("Refine_1.stl")
