
import cadquery as cq

# Define the dimensions
length_vertical = 100.0
width = 20.0
thickness = 5.0
length_horizontal = length_vertical / 4

# Create the vertical rectangle
result = cq.Workplane("front").rect(width, length_vertical).extrude(thickness)

# Create the horizontal rectangle
# Updated to position the rectangle closer to the top but below the very top
result = result.faces(">Z").workplane().center(0, length_vertical * 3/4 - length_horizontal/2).rect(width, length_horizontal).extrude(thickness)

# Export the result
result.val().exportStl("Refine_2.stl")
