
import cadquery as cq

# Parameters
base_length = 10.0
height = 15.0
corner_radius = 1.0
hole_radius = 0.2
top_cut_position = 0.6  # Position of the top cut relative to height (as a fraction)
thickness = 1.0  # Extrusion thickness

# Create an initial isosceles triangle
triangle = (
    cq.Workplane("XY")
    .moveTo(-base_length / 2, 0)
    .lineTo(base_length / 2, 0)
    .lineTo(0, height)
    .close()
)

# Create rounded bottom corners and a straight top edge cut
triangle_modified = (
    triangle
    .workplane()
    .moveTo(0, height * top_cut_position)
    .lineTo(-base_length / 2, 0)
    .lineTo(base_length / 2, 0)
    .close()
    .edges("<Y")  # Select the bottom edges
    .fillet(corner_radius)
)

# Extrude the modified triangle
ext_triangle = triangle_modified.extrude(thickness)

# Adding holes
# Points for holes placement calculated based on distance from corresponding corners
offset = 0.5  # Arbitrary small offset from each corner for the holes
hole_points = [
    (-base_length / 2 + offset, offset),
    (base_length / 2 - offset, offset),
    (0, height * top_cut_position - offset)
]

for point in hole_points:
    ext_triangle = ext_triangle.faces(">Z").workplane().pushPoints([point]).hole(hole_radius)

# Export the modified model
ext_triangle.val().exportStl("Refine_2.stl")
