
import cadquery as cq
import math

# Define the points for the pentagon making the first defined edge the bottom and shortest
points = [(0, 0), (1, 0), (1.8, 1.5), (0.5, 2.5), (-0.8, 1.5)]

# Calculate the height of the pentagon as the difference between the max and min y-values
pentagon_height = max(points, key=lambda x: x[1])[1] - min(points, key=lambda x: x[1])[1]

# Ensure the first edge is the shortest by measurement or define it shorter if not in theory
lowest_edge_length = math.dist(points[0], points[1])  # Calculates distance between first two points

# Create the workplane, draw the pentagon
r = cq.Workplane("front").polyline(points).close()

# Extrude the sketch to create the 3D pentagonal prism, extrusion is almost two times the pentagon height
extrusion_height = 2 * pentagon_height * 0.95  # Using 0.95 to approximate "almost two times"
result = r.extrude(extrusion_height)

# Save the output
result.val().exportStl("Refine_2.stl")
