
import cadquery as cq
import math

# Define the side length of the equilateral triangle
side_length = 10.0

# Calculate the height of the equilateral triangle
height = side_length * math.sqrt(3) / 2

# Define the radius of the semicircular cutout
radius = side_length * 2 / 3 / 2

# Define the points of the equilateral triangle
pts = [
    (-side_length / 2, -height / 2),
    (side_length / 2, -height / 2),
    (0, height / 2),
]

# Create the workplane and draw the triangle
result = cq.Workplane("front").polyline(pts).close()

# Cutout the semicircle from the bottom edge of the triangle
# Calculate the center of the semicircle using height and edge length
cutout_center_x = -radius  # Starting at the left bottom corner offset by the radius
cutout_center_y = -height / 2 + radius  # The vertical position of the center of the semicircle
result = result.moveTo(cutout_center_x * 2, cutout_center_y).\
    threePointArc((cutout_center_x, cutout_center_y - radius), (cutout_center_x + 2 * radius, cutout_center_y)).\
    lineTo(result.vertices().objects[0].X, result.vertices().objects[0].Y).close()  # Closing the path

# Extrude the sketch to create a 3D object
result = result.extrude(10.0)

# Export the result
result.val().exportStl("Refine_1.stl")
