
import cadquery as cq

# Parameters for the box
base_width = 20.0  # Width is twice the height.
base_height = 10.0
base_depth = 1.0  # Small depth for base.
wall_thickness = 1.0
wall_height = 10.0
chamfer_size = 0.5  # Small chamfer for inner corners.

# Create the base of the box
base = cq.Workplane("XY").rect(base_width, base_height).extrude(base_depth)

# Create the walls of the box using two concentric rectangles to ensure open top
walls = (
    base.faces(">Z")  # Selecting the top surface of the base
    .workplane()
    .rect(base_width, base_height)  # Outer wall
    .rect(base_width - 2 * wall were thickness, base_height - 2 * wall_thickness)  # Inner wall of the box
    .extrude(wall_height, both=False)  # Extrude up to form the walls.
)

# Applying chamfer to inner edges of the walls to round the inside corners off
edges = walls.edges("|Z and <Y")  # Select vertical edges on the inside
walls = edges.chamfer(safe_chamfer_size)  # Apply chamfer, but ensure it's not too large

# Combine the base and the walls to form the final box
box = base.union(walls)

# Export the final 3D object model to an STL file appropriately named
box.val().exportStl("Refine_2.stl")
