
import cadquery as cq

# Define the dimensions
length = 10.0
width1 = 5.0  # Width of the base rectangle
width2 = 3.0  # Width of the upper rectangle
height = 2.0  # Height of each extrusion
hole_diameter = 1.0

# Create the base rectangle
result = cq.Workplane("XY").rect(length, width1).extrude(height)

# The upper smaller rectangle should be positioned at one end of the larger rectangle.
# Adjusting the position by translating it to be at one end.
result = result.faces(">Z").workplane().rect(length, width2).translate((-width1/2 + width2/2, 0, 0)).extrude(height)

# The circular hole should be centered on the upper rectangle. Adjusting its position based on new placement of the rectangle.
result = result.faces(">Z").workplane().center(-width1/2 + width2/2, 0).circle(hole_diameter / 2).cutThruAll()

# Export the result
result.val().exportStl("Refine_2.stl")
