
import cadquery as cq

# Define the dimensions
width = 30.0
height = 10.0
depth = 2.0
cutout_width = 2.0
cutout_height_left = 6.0
cutout_height_right = 2.0

# PLEASE NOTE: Adjust the left cutout width to make it three times longer than the right cutout.
cutout_width_left = 3 * cutout_width

# Create the base rectangle
result = cq.Workplane("front").rect(width, height).extrude(depth)

# Place the left cutout: ensure cutout is three times longer than the right one and appears on the left edge
result = result.faces("<Y").workplane().rect(cutout_width_left, cutout_height_left).translate((-width/2 + cutout_width_left/2, 0)).cutBlind(-depth)

# Place the right cutout: ensure cutout appears on the right edge
result = result.faces(">Y").workplane().rect(cutout_width, cutout_height_right).translate((width/2 - cutout_width/2, 0)).cutBlind(-depth)

# Export the result to STL with the corrected name
result.val().exportStl("Refine_2.stl")
